/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.data.CfgItemOptions;
import frc.emul.config.handler.CLHConfiguration;
import frc.emul.config.handler.CLHDisplayChassis;
import frc.emul.config.handler.CLHShaders;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import frc.util.xml.XMLLoaderHandlerFactor;
import org.xml.sax.Attributes;

public class CLHDisplay
extends ConfigLoaderHandler {
    final Level level;

    public CLHDisplay(CLHConfiguration cLHConfiguration) {
        super(cLHConfiguration);
        this.level = Level.ROOT;
    }

    private CLHDisplay(CLHDisplay cLHDisplay, Level level) {
        super(cLHDisplay);
        this.level = level;
    }

    public void pushed(Attributes attributes) {
        CfgItemOptions cfgItemOptions = this.getConfig().options;
        switch (this.level) {
            case ROOT: {
                cfgItemOptions.display_overlay_mode = CLHDisplay.loadInt(attributes, "overlayMode", cfgItemOptions.display_overlay_mode);
                cfgItemOptions.display_antialiasing = CLHDisplay.loadBool(attributes, "aa", cfgItemOptions.display_antialiasing);
                cfgItemOptions.display_additive_blend = CLHDisplay.loadBool(attributes, "additive", cfgItemOptions.display_additive_blend);
                cfgItemOptions.display_overlay = CLHDisplay.loadBool(attributes, "overlay", cfgItemOptions.display_overlay);
                cfgItemOptions.display_persistence = CLHDisplay.loadBool(attributes, "persistent", cfgItemOptions.display_persistence);
                cfgItemOptions.display_fullscreen = CLHDisplay.loadBool(attributes, "fullscreen", cfgItemOptions.display_fullscreen);
                cfgItemOptions.display_full_viewport = CLHDisplay.loadBool(attributes, "fullViewport", cfgItemOptions.display_full_viewport);
                int n = CLHDisplay.loadInt(attributes, "rotation", cfgItemOptions.display_rotation);
                cfgItemOptions.display_rotation = n % 360 - n % 90;
                float f = CLHDisplay.loadFloat(attributes, "gamma", cfgItemOptions.display_gamma);
                cfgItemOptions.display_gamma = Math.max(0.01f, Math.min(3.0f, f));
                int n2 = CLHDisplay.loadInt(attributes, "brightness", 100);
                cfgItemOptions.display_brightness = 100.0f / (float)Math.max(1, Math.min(300, n2));
                break;
            }
            case THICKNESS: {
                float f = CLHDisplay.loadFloat(attributes, "points", cfgItemOptions.display_size_points);
                cfgItemOptions.display_size_points = Math.max(0.1f, Math.min(6.0f, f));
                float f2 = CLHDisplay.loadFloat(attributes, "lines", cfgItemOptions.display_size_lines);
                cfgItemOptions.display_size_lines = Math.max(0.1f, Math.min(3.5f, f2));
            }
        }
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        switch (this.level) {
            case ROOT: {
                if (string.equals("chassis")) {
                    return new CLHDisplayChassis(this);
                }
                if (string.equals("vectors")) {
                    return new CLHDisplay(this, Level.VECTORS);
                }
                if (!string.equals("shaders")) break;
                return new CLHShaders(this);
            }
            case VECTORS: {
                if (string.equals("thickness")) {
                    return new CLHDisplay(this, Level.THICKNESS);
                }
                if (!string.equals("wobbling")) break;
                return this.createWobblingChild();
            }
        }
        return super.getChildHandler(string, attributes);
    }

    private XMLLoaderHandler createWobblingChild() {
        return new XMLLoaderHandlerFactor(this, (Object)this.getConfig().options, "display_wobbling", "display_wobbling_factor", 0.0f, 10.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        ROOT,
        VECTORS,
        THICKNESS;

    }
}

